﻿//////////////////////////////////////////////
// DataAllocator.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class BlendState ;
	class Buffer ;
	class ClearTargetsPass ;
	class Compositor ;
	class ComputePass ;
	class ComputeProgram ;
	class DepthStencilState ;
	class GeometryProgram ;
	class InstancingPass ;
	class Mesh ;
	class MonoMaterialPass ;
	class PipelineProgram ;
	class PostProcessPass ;
	class ProfilingHelper ;
	class Program ;
	class RasterState ;
	class RaytracingPass ;
	class RenderContext ;
	class RenderQueue ;
	class RenderScenePass ;
	class Sampler ;
	class Shader ;
	class System ;
	class Texture ;
	class Viewport ;
}

/// Class ------------------------------------

namespace nkGraphics
{
	class DataAllocator
	{
		public :
	
			// Constructor, destructor
			DataAllocator () noexcept ;
			virtual ~DataAllocator () ;

			// Allocation des blocks mémoire
			virtual Buffer* allocateBuffer () = 0 ;

			virtual Mesh* allocateMesh () = 0 ;

			virtual BlendState* allocateBlendState () = 0 ;
			virtual DepthStencilState* allocateDepthStencilState () = 0 ;
			virtual RasterState* allocateRasterState () = 0 ;

			virtual Sampler* allocateSampler () = 0 ;
			virtual Texture* allocateTexture () = 0 ;

			virtual Compositor* allocateCompositor () = 0 ;

			virtual ClearTargetsPass* allocateClearTargetsPass () = 0 ;
			virtual ComputePass* allocateComputePass () = 0 ;
			virtual InstancingPass* allocateInstancingPass () = 0 ;
			virtual MonoMaterialPass* allocateMonoMaterialPass () = 0 ;
			virtual PostProcessPass* allocatePostProcessPass () = 0 ;
			virtual RaytracingPass* allocateRaytracingPass () = 0 ;
			virtual RenderScenePass* allocateRenderScenePass () = 0 ;

			virtual Viewport* allocateViewport () = 0 ;

			virtual RenderContext* allocateRenderContext () = 0 ;

			virtual RenderQueue* allocateRenderQueue () = 0 ;

			virtual Program* allocateProgram () = 0 ;

			virtual Shader* allocateShader () = 0 ;

			virtual ProfilingHelper* allocateProfilingHelper () = 0 ;
	} ;
}